/*===========================================================================
  SAMPLE.H

  C include file for sample functions

  Copyright (c) 1993-1995 ATI Technologies Inc.  All rights reserved
 ===========================================================================*/

#define TRUE                        1
#define FALSE                       0

/* Function constants */

// BIOS interface constants
#define MODE_640x480                0x12
#define MODE_800x600                0x6A
#define MODE_1024x768               0x55
#define MODE_1280x1024              0x83

#define PITCH_1024                  0
#define PITCH_NOCHANGE              1
#define PITCH_XRES                  2

#define COLOR_DEPTH_4               1
#define COLOR_DEPTH_8               2
#define COLOR_DEPTH_15              3
#define COLOR_DEPTH_16              4
#define COLOR_DEPTH_24              5
#define COLOR_DEPTH_32              6

#define DEPTH_SUPPORT_ARGB          0x80
#define DEPTH_SUPPORT_BGRA          0x40
#define DEPTH_SUPPORT_RGBA          0x20
#define DEPTH_SUPPORT_ABGR          0x10
#define DEPTH_SUPPORT_BGR           0x08
#define DEPTH_SUPPORT_RGB           0x04
#define DEPTH_SUPPORT_555           0x02
#define DEPTH_SUPPORT_565           0x01

#define ACCELERATOR_MODE            1
#define VGA_MODE                    0

#define NO_ERROR                    0
#define YES_ERROR                   1
#define NOT_SUPPORTED               2

#define APERTURE_ENABLE_FAILURE     0
#define APERTURE_VGA_ENABLE_SUCCESS 1
#define APERTURE_4M_ENABLE_SUCCESS  2
#define APERTURE_8M_ENABLE_SUCCESS  3
#define HWCURSOR_ENABLE_FAILURE     0
#define HWCURSOR_ENABLE_SUCCESS     1

// Detection contants
#define NO_MACH64                   0
#define YES_MACH64                  1

// Query constants
#define HEADER_ONLY                 0
#define HEADER_AND_MODE             1

// Other constants
#define MEM_WRITE                   1
#define MEM_READ                    0

// Mach64 'chip_type' id constants
#define CHIP_GX_ID                  0x00D7
#define CHIP_CX_ID                  0x0057
#define CHIP_CT_ID                  0x4354

// DAC BYTE index constants for ioDAC_REGS register -- can be used with
// ior8() or iow8()
#define DAC_W_INDEX                 0
#define DAC_DATA                    1
#define DAC_MASK                    2
#define DAC_R_INDEX                 3

// Waitforidle() and Waitforfifo() errors and constants
#define BAD_IDLE                    0
#define BAD_FIFO                    1
#define DOS_TICK_ADDRESS            0x0000046C
#define IDLE_TIMEOUT                50
#define FIFO_TIMEOUT                50

// VGA aperture address constants
#define VGA_REGISTER_BASE           0xB000FC00
#define LOW_APERTURE_BASE           0xA0000000
#define HIGH_APERTURE_BASE          0xA8000000

// Mix control values for setfgmix() and setbgmix() functions
#define NOT_D_MIX                   0
#define ZERO_MIX                    1
#define ONE_MIX                     2
#define D_MIX                       3
#define NOT_S_MIX                   4
#define D_XOR_S_MIX                 5
#define NOT_D_XOR_S_MIX             6
#define S_MIX                       7
#define NOT_D_OR_NOT_S_MIX          8
#define D_OR_NOT_S_MIX              9
#define NOT_D_OR_S_MIX              10
#define D_OR_S_MIX                  11
#define D_AND_S_MIX                 12
#define NOT_D_AND_S_MIX             13
#define D_AND_NOT_S_MIX             14
#define NOT_D_AND_NOT_S_MIX         15
#define D_PLUS_S_DIV2_MIX           23

// Status codes used in MODECFG structure */
#define LINEAR_APERTURE_ENABLED     1
#define LINEAR_APERTURE_DISABLED    0
#define VGA_APERTURE_ENABLED        1
#define VGA_APERTURE_DISABLED       0

// Generic color definitions for use in getcolorcode() function
#define BLACK                       0
#define DARKBLUE                    1
#define DARKGREEN                   2
#define DARKCYAN                    3
#define DARKRED                     4
#define DARKMAGENTA                 5
#define BROWN                       6
#define LIGHTGRAY                   7
#define DARKGRAY                    8
#define LIGHTBLUE                   9
#define LIGHTGREEN                  10
#define LIGHTCYAN                   11
#define LIGHTRED                    12
#define LIGHTMAGENTA                13
#define YELLOW                      14
#define WHITE                       15

// Color codes for 4 & 8 bpp modes - palette entry based
#define DARKBLUE8                   0x00000001
#define DARKGREEN8                  0x00000002
#define DARKCYAN8                   0x00000003
#define DARKRED8                    0x00000004
#define DARKMAGENTA8                0x00000005
#define BROWN8                      0x00000006
#define LIGHTGRAY8                  0x00000007
#define DARKGRAY8                   0x00000008
#define LIGHTBLUE8                  0x00000009
#define LIGHTGREEN8                 0x0000000A
#define LIGHTCYAN8                  0x0000000B
#define LIGHTRED8                   0x0000000C
#define LIGHTMAGENTA8               0x0000000D
#define YELLOW8                     0x0000000E
#define WHITE8                      0x0000000F
#define HIWHITE8                    0x000000FF

// Color codes for 15 bpp (16 bpp 555 color weight) modes - direct mapped
#define DARKBLUE15                  0x00000014
#define DARKGREEN15                 0x00000280
#define DARKCYAN15                  0x00000294
#define DARKRED15                   0x00005000
#define DARKMAGENTA15               0x00005014
#define BROWN15                     0x00005280
#define LIGHTGRAY15                 0x00005294
#define DARKGRAY15                  0x0000294A
#define LIGHTBLUE15                 0x0000001F
#define LIGHTGREEN15                0x000003E0
#define LIGHTCYAN15                 0x000003FF
#define LIGHTRED15                  0x00007C00
#define LIGHTMAGENTA15              0x00007C1F
#define YELLOW15                    0x00007FE0
#define WHITE15                     0x0000FFFF

// Color codes for 16 bpp (16 bpp 565 color weight) modes - direct mapped
#define DARKBLUE16                  0x00000014
#define DARKGREEN16                 0x000004C0
#define DARKCYAN16                  0x000004D4
#define DARKRED16                   0x0000A000
#define DARKMAGENTA16               0x0000A014
#define BROWN16                     0x0000A4C0
#define LIGHTGRAY16                 0x0000A4D4
#define DARKGRAY16                  0x0000528A
#define LIGHTBLUE16                 0x0000001F
#define LIGHTGREEN16                0x000007E0
#define LIGHTCYAN16                 0x000007FF
#define LIGHTRED16                  0x0000F800
#define LIGHTMAGENTA16              0x0000F81F
#define YELLOW16                    0x0000FFE0
#define WHITE16                     0x0000FFFF

// Color codes for 24 bpp RGB color weight modes - direct mapped
#define DARKBLUE24_RGB              0x0000009E
#define DARKGREEN24_RGB             0x00009E00
#define DARKCYAN24_RGB              0x00009E9E
#define DARKRED24_RGB               0x009E0000
#define DARKMAGENTA24_RGB           0x009E009E
#define BROWN24_RGB                 0x009E9E00
#define LIGHTGRAY24_RGB             0x009E9E9E
#define DARKGRAY24_RGB              0x00555555
#define LIGHTBLUE24_RGB             0x000000FF
#define LIGHTGREEN24_RGB            0x0000FF00
#define LIGHTCYAN24_RGB             0x0000FFFF
#define LIGHTRED24_RGB              0x00FF0000
#define LIGHTMAGENTA24_RGB          0x00FF00FF
#define YELLOW24_RGB                0x00FFFF00
#define WHITE24_RGB                 0x00FFFFFF

// Color codes for 24 bpp BGR color weight modes - direct mapped
#define DARKBLUE24_BGR              0x009E0000
#define DARKGREEN24_BGR             0x00009E00
#define DARKCYAN24_BGR              0x009E9E00
#define DARKRED24_BGR               0x0000009E
#define DARKMAGENTA24_BGR           0x009E009E
#define BROWN24_BGR                 0x00009E9E
#define LIGHTGRAY24_BGR             0x009E9E9E
#define DARKGRAY24_BGR              0x00555555
#define LIGHTBLUE24_BGR             0x00FF0000
#define LIGHTGREEN24_BGR            0x0000FF00
#define LIGHTCYAN24_BGR             0x00FFFF00
#define LIGHTRED24_BGR              0x000000FF
#define LIGHTMAGENTA24_BGR          0x00FF00FF
#define YELLOW24_BGR                0x0000FFFF
#define WHITE24_BGR                 0x00FFFFFF

// Color codes for 32 bpp RGBA color weight modes - direct mapped
#define DARKBLUE32_RGBA             0x00009E00
#define DARKGREEN32_RGBA            0x009E0000
#define DARKCYAN32_RGBA             0x009E9E00
#define DARKRED32_RGBA              0x9E000000
#define DARKMAGENTA32_RGBA          0x9E009E00
#define BROWN32_RGBA                0x9E9E0000
#define LIGHTGRAY32_RGBA            0x9E9E9E00
#define DARKGRAY32_RGBA             0x55555500
#define LIGHTBLUE32_RGBA            0x0000FF00
#define LIGHTGREEN32_RGBA           0x00FF0000
#define LIGHTCYAN32_RGBA            0x00FFFF00
#define LIGHTRED32_RGBA             0xFF000000
#define LIGHTMAGENTA32_RGBA         0xFF00FF00
#define YELLOW32_RGBA               0xFFFF0000
#define WHITE32_RGBA                0xFFFFFF00

// Color codes for 32 bpp BGRA color weight modes - direct mapped
#define DARKBLUE24_BGRA             0x9E000000
#define DARKGREEN24_BGRA            0x009E0000
#define DARKCYAN24_BGRA             0x9E9E0000
#define DARKRED24_BGRA              0x00009E00
#define DARKMAGENTA24_BGRA          0x9E009E00
#define BROWN24_BGRA                0x009E9E00
#define LIGHTGRAY24_BGRA            0x9E9E9E00
#define DARKGRAY24_BGRA             0x55555500
#define LIGHTBLUE24_BGRA            0xFF000000
#define LIGHTGREEN24_BGRA           0x00FF0000
#define LIGHTCYAN24_BGRA            0xFFFF0000
#define LIGHTRED24_BGRA             0x0000FF00
#define LIGHTMAGENTA24_BGRA         0xFF00FF00
#define YELLOW24_BGRA               0x00FFFF00
#define WHITE24_BGRA                0xFFFFFF00


// Macro for 24 bpp alignment - x is expressed in 24 bpp
#define GET24BPPROTATION(x)  (unsigned long)(((x * 3) / 4) % 6)


/* Engine bit constants - these are typically ORed together */

// GEN_TEST_CNTL register constants
#define HWCURSOR_ENABLE             0x80
#define GUI_ENGINE_ENABLE           0x100

// CONFIG_CNTL register constants
#define APERTURE_4M_ENABLE          1
#define APERTURE_8M_ENABLE          2
#define VGA_APERTURE_ENABLE         4

// DST_CNTL register constants
#define DST_X_RIGHT_TO_LEFT         0
#define DST_X_LEFT_TO_RIGHT         1
#define DST_Y_BOTTOM_TO_TOP         0
#define DST_Y_TOP_TO_BOTTOM         2
#define DST_X_MAJOR                 0
#define DST_Y_MAJOR                 4
#define DST_X_TILE                  8
#define DST_Y_TILE                  0x10
#define DST_LAST_PEL                0x20
#define DST_POLYGON_ENABLE          0x40
#define DST_24_ROTATION_ENABLE      0x80

// SRC_CNTL register constants
#define SRC_PATTERN_ENABLE          1
#define SRC_ROTATION_ENABLE         2
#define SRC_LINEAR_ENABLE           4
#define SRC_BYTE_ALIGN              8
#define SRC_LINE_X_RIGHT_TO_LEFT    0
#define SRC_LINE_X_LEFT_TO_RIGHT    0x10

// HOST_CNTL register constants
#define HOST_BYTE_ALIGN             1

// PAT_CNTL register constants
#define PAT_MONO_8x8_ENABLE         1
#define PAT_CLR_4x2_ENABLE          2
#define PAT_CLR_8x1_ENABLE          4

// DP_PIX_WIDTH register constants
#define DST_1BPP                    0
#define DST_4BPP                    1
#define DST_8BPP                    2
#define DST_15BPP                   3
#define DST_16BPP                   4
#define DST_32BPP                   6
#define SRC_1BPP                    0
#define SRC_4BPP                    0x100
#define SRC_8BPP                    0x200
#define SRC_15BPP                   0x300
#define SRC_16BPP                   0x400
#define SRC_32BPP                   0x600
#define HOST_1BPP                   0
#define HOST_4BPP                   0x10000
#define HOST_8BPP                   0x20000
#define HOST_15BPP                  0x30000
#define HOST_16BPP                  0x40000
#define HOST_32BPP                  0x60000
#define BYTE_ORDER_MSB_TO_LSB       0
#define BYTE_ORDER_LSB_TO_MSB       0x1000000

// DP_MIX register constants
#define BKGD_MIX_NOT_D              0
#define BKGD_MIX_ZERO               1
#define BKGD_MIX_ONE                2
#define BKGD_MIX_D                  3
#define BKGD_MIX_NOT_S              4
#define BKGD_MIX_D_XOR_S            5
#define BKGD_MIX_NOT_D_XOR_S        6
#define BKGD_MIX_S                  7
#define BKGD_MIX_NOT_D_OR_NOT_S     8
#define BKGD_MIX_D_OR_NOT_S         9
#define BKGD_MIX_NOT_D_OR_S         10
#define BKGD_MIX_D_OR_S             11
#define BKGD_MIX_D_AND_S            12
#define BKGD_MIX_NOT_D_AND_S        13
#define BKGD_MIX_D_AND_NOT_S        14
#define BKGD_MIX_NOT_D_AND_NOT_S    15
#define BKGD_MIX_D_PLUS_S_DIV2      0x17
#define FRGD_MIX_NOT_D              0
#define FRGD_MIX_ZERO               0x10000
#define FRGD_MIX_ONE                0x20000
#define FRGD_MIX_D                  0x30000
#define FRGD_MIX_NOT_S              0x40000
#define FRGD_MIX_D_XOR_S            0x50000
#define FRGD_MIX_NOT_D_XOR_S        0x60000
#define FRGD_MIX_S                  0x70000
#define FRGD_MIX_NOT_D_OR_NOT_S     0x80000
#define FRGD_MIX_D_OR_NOT_S         0x90000
#define FRGD_MIX_NOT_D_OR_S         0xA0000
#define FRGD_MIX_D_OR_S             0xB0000
#define FRGD_MIX_D_AND_S            0xC0000
#define FRGD_MIX_NOT_D_AND_S        0xD0000
#define FRGD_MIX_D_AND_NOT_S        0xE0000
#define FRGD_MIX_NOT_D_AND_NOT_S    0xF0000
#define FRGD_MIX_D_PLUS_S_DIV2      0x170000

// DP_SRC register constants
#define BKGD_SRC_BKGD_CLR           0
#define BKGD_SRC_FRGD_CLR           1
#define BKGD_SRC_HOST               2
#define BKGD_SRC_BLIT               3
#define BKGD_SRC_PATTERN            4
#define FRGD_SRC_BKGD_CLR           0
#define FRGD_SRC_FRGD_CLR           0x100
#define FRGD_SRC_HOST               0x200
#define FRGD_SRC_BLIT               0x300
#define FRGD_SRC_PATTERN            0x400
#define MONO_SRC_ONE                0
#define MONO_SRC_PATTERN            0x10000
#define MONO_SRC_HOST               0x20000
#define MONO_SRC_BLIT               0x30000

// CLR_CMP_CNTL register constants
#define COMPARE_FALSE               0
#define COMPARE_TRUE                1
#define COMPARE_NOT_EQUAL           4
#define COMPARE_EQUAL               5
#define COMPARE_DESTINATION         0
#define COMPARE_SOURCE              0x1000000

// FIFO_STAT register constants
#define FIFO_ERR                    0x80000000

// CONTEXT_LOAD_CNTL constants
#define CONTEXT_NO_LOAD             0
#define CONTEXT_LOAD                0x10000
#define CONTEXT_LOAD_AND_DO_FILL    0x20000
#define CONTEXT_LOAD_AND_DO_LINE    0x30000
#define CONTEXT_EXECUTE             0
#define CONTEXT_CMD_DISABLE         0x80000000

// GUI_STAT register constants
#define ENGINE_IDLE                 0
#define ENGINE_BUSY                 1
#define SCISSOR_LEFT_FLAG           0x10
#define SCISSOR_RIGHT_FLAG          0x20
#define SCISSOR_TOP_FLAG            0x40
#define SCISSOR_BOTTOM_FLAG         0x80


// Bus types from CONFIG_STAT0 bits 2:0
#define BUS_ISA                     0
#define BUS_EISA                    1
#define BUS_VLB                     6
#define BUS_PCI                     7

// 'dac_type' constants from ROM query header
// -lower 4 bits is DAC main type
// -upper 4 bits is DAC sub type
// -DACs other than TVP3026 will have a different sub type than 7
//
#define DAC_INTERNAL                0x00    // CT, internal DAC
#define DAC_IBM514                  0x01
#define DAC_ATI68875                0x02    // also TLC34075
#define DAC_TVP3026_1               0x72    // same as DAC_TVP3026_2
#define DAC_BT476                   0x03    // also BT478
#define DAC_BT481                   0x04
#define DAC_ATT20C490               0x14    // also ATT20C491/493, IMS-G174,
                                            //  SC15025/15026, MU9C4910/1880
#define DAC_ATI68860_1              0x05    // rev B
#define DAC_ATI68860_2              0x15    // rev C
#define DAC_TVP3026_2               0x75    // same as DAC_TVP3026_1
#define DAC_STG1700                 0x06
#define DAC_ATT20C498               0x16
#define DAC_STG1702                 0x07
#define DAC_SC15021                 0x17
#define DAC_ATT21C498               0x27
#define DAC_STG1703                 0x37
#define DAC_CH8398                  0x47

// Vga type from CONFIG_STAT0 bit 23
#define VGA_ENABLE                  1
#define VGA_DISABLE                 0


/* Hardware cursor bitmap dimensions */
#define HWCURWIDTH                  8       // width of hwcursor in words
#define HWCURHEIGHT                 64      // height of hwcursor in scan lines

#define GEN_BLOCK_WR_EN             0x200

/* Ensure that all structures are BYTE aligned -- same as /Zp1 CL option */
#pragma pack(1)

/* Global user structures */

typedef enum {BLUE, GREEN, RED} PRIMARYCOLOR;

typedef struct
{
    int y;
    int width;
    int height;
    int current_x;
    int current_y;
    int hot_x;
    int hot_y;
    unsigned long cur_offset;
    unsigned long color0;
    unsigned long color1;
    unsigned int bitmap[HWCURHEIGHT * HWCURWIDTH];
} HWCURSOR;

typedef struct
{
    int red;
    int green;
    int blue;
} PALETTE;

typedef struct
{
    int x, y;
} POINT;

typedef struct
{
    int left, top, right, bottom;
} SCISSOR;

typedef struct
{
    int xres;
    int yres;
    int bpp;                        // 4, 8, 16, 24, 32
    int depth;                      // 555 for 15 bpp, 565 for 16 bpp
    int pitch;
    int vga_aperture_status;        // VGA_APERTURE_ENABLE, VGA_APERTURE_DISABLE
    int linear_aperture_status;     // APERTURE_4M_ENABLE, APERTURE_8M_ENABLE
    int linear_aperture_size;       // APERTURE_4M_ENABLE, APERTURE_8M_ENABLE
    unsigned long aperture_address; // linear aperture address
    unsigned long vga_memreg_offset;
    unsigned long linear_memreg_offset;
} MODECFG;

typedef struct                      // See MACH 64 BIOS extension info
{
    unsigned short size;
    unsigned char revision;
    unsigned char mode_tables;
    unsigned short mode_table_offset;
    unsigned char mode_table_size;
    unsigned char vga_type;         // See VGA types
    unsigned short asic_id;
    unsigned char vga_boundary;
    unsigned char memory_size;
    unsigned char dac_type;         // See DAC types
    unsigned char memory_type;
    unsigned char bus_type;         // See BUS types
    unsigned char monitor_cntl;
    unsigned short aperture_addr;
    unsigned char aperture_cfg;
    unsigned char color_depth_support;
    unsigned char ramdac_feature_support;
    unsigned char io_type;
    unsigned short reserved1;
    unsigned short io_base;
    unsigned char reserved2[6];
} QUERY_STRUCTURE;


typedef struct                      // ROM I/O base query structure
{
    unsigned int io_base;
    unsigned int io_type;
} IOBASEQUERY;

typedef struct
{
    int instance;
    unsigned int rom_segment;
} INSTANCEINFO;

/* Resume word alignment */
#pragma pack()

/* Function declarations */

// Routines from ATTR.C
unsigned long get_color_code (int generic_color);
void set_fg_color (unsigned long color);
unsigned long get_fg_color (void);
void set_bg_color (unsigned long color);
unsigned long get_bg_color (void);
void set_fg_mix (int mix);
int  get_fg_mix (void);
void set_bg_mix (int mix);
int  get_bg_mix (void);
unsigned long get_primary_color (PRIMARYCOLOR primarycolor,
                                 unsigned long color);
unsigned long get_xy_offset (int x, int y);

// Routines from DRAW.C
void blit (int x1, int y1, int x2, int y2, int width, int height);
void clear_screen (int x, int y, int width, int height);
void draw_rectangle (int x, int y, int width, int height);
void draw_line (int x1, int y1, int x2, int y2);
void draw_line24 (int x1, int y1, int x2, int y2);

// Routines from HWCURSOR.C
void set_hwcursor (int y, int width, int height, int hot_x, int hot_y,
                   unsigned long color0, unsigned long color1,
                   unsigned int *bitmap);
void enable_hwcursor (void);
void disable_hwcursor (void);
void set_hwcursor_pos (int x, int y);
void get_hwcursor_pos (POINT *position);
void set_cursor_colors (unsigned long color0, unsigned long color1);

// Routines from INIT.C
int  detect_mach64 (int instance);
void init_4bpp (void);
void init_8bpp (void);
void init_15bpp (void);
void init_16bpp (void);
void init_24bpp (void);
void init_32bpp (void);
void reset_engine (void);
void init_engine (void);
int  open_mode (int mode_code, int pitch_code, int color_code);
void close_mode (void);
int enable_vga_aperture (void);
void disable_vga_aperture (void);
int enable_linear_aperture (int aperture_size);
void disable_linear_aperture (void);
int init_aperture (void);
void update_aperture_status (void);
int  query_hardware (void);
void set_packed_pixel (void);
void process_command_line (int argc, char **argv);

// Routines from MEMREG.C
void vga_regw (unsigned int regindex, unsigned long regdata);
unsigned long vga_regr (unsigned int regindex);
void app_regw (unsigned int regindex, unsigned long regdata);
unsigned long app_regr (unsigned int regindex);
void regw (unsigned int regindex, unsigned long regdata);
unsigned long regr (unsigned int regindex);

// Routines from PALETTE.C
void set_palette (int index, PALETTE entry);
PALETTE get_palette (int index);
void save_palette (PALETTE *palettebuffer);
void restore_palette (PALETTE *palettebuffer);
void init_palette (void);
void init_palettized (void);

// Routines from WAIT.C
void wait_for_idle (void);
void wait_for_fifo (int entries);
void terminate (int idle_problem);

// Routines from AREGW.ASM
void aregw (unsigned int regindex, unsigned long regdata);

// Routines from MOVEMEM.ASM
int movemem (void far *ptr, unsigned long phyaddr,
             unsigned int nwords, int direction);

// Routines from ROMCALLS.ASM
int load_mode_parms (int resolution_code, int pitch_code,
                     int color_depth_code);
int set_display_mode (int display_mode);
int load_and_set_mode (int resolution_code, int pitch_code,
                       int color_depth_code);
int get_query_size (int info_type);
int fill_query_structure (int info_type, unsigned char far *ptr);
int get_io_base (void far *lpiobaseinfo);

// Routines from ROMSEG.ASM
int is_ati_rom (int segment);
int is_mach64_rom (int segment);
void set_rom_base (int segment);
int get_rom_base (void);

// Routines from IOREG.ASM
void init_io_reg (unsigned int base, unsigned int type);
void iow8 (unsigned int ioaddr, unsigned int data);
unsigned int ior8 (unsigned int ioaddr);
void iow16 (unsigned int ioaddr, unsigned int data);
unsigned int ior16 (unsigned int ioaddr);
void iow32 (unsigned int ioaddr, unsigned long data);
unsigned long ior32 (unsigned int ioaddr);

/* External variable and array declarations */

extern MODECFG modeinfo;
extern HWCURSOR cursordata;
extern QUERY_STRUCTURE querydata;
extern IOBASEQUERY iobaseinfo;
extern INSTANCEINFO instanceinfo;
extern PALETTE savepalette[256];
extern int mem_cntl;
extern int gmode_res;
extern int gclr_depth;

