/*==========================================================================
* VMEM.C - Copyright (c) 1993-94 ATI Technologies Inc. All rights reserved *
*                                                                          *
* PGL functions to read screen memory directly (without engine).           *
* ======================================================================== */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>

#include "..\inc\atim64.h"
#include "..\inc\pgl.h"
#include "..\inc\pglglob.h"

/* --------------------------------------------------------------------------
  PGL_getpixel - read a pixel of data from screen memory.

  A pixel value at (x, y) is returned. This function uses either the vga
  or linear aperture for retrieving the data. The aperture status is checked
  to determine the type of access.
-------------------------------------------------------------------------- */
unsigned long PGL_getpixel(int x, int y)
{
    unsigned long startaddr, pixel;
    unsigned long readpage, readoffset;

    startaddr = pgl_getxyoffset(x, y);

    if (PGL_modecfg.vga_aperture_status == VGA_APERTURE_ENABLED)
    {
        // set read pointer to address
        readpage = startaddr / 0x8000;
        readoffset = startaddr - (readpage * 0x8000);

        // set 32k VGA aperture pointer and read pixel value
        regw(MEM_VGA_RP_SEL, (int)readpage);
        pixel = *((unsigned long far *)(0xa0000000 + readoffset));
    }
    else
    {
        pgl_movemem((void far *)(&pixel), PGL_modecfg.aperture_address + startaddr,
                    2, MEM_READ);
    }

    switch (PGL_modecfg.bpp)
    {
        case 4:
            if ((x & 1) == 1)  // odd case
            {
                pixel = pixel & 0x0000000f;
            }
            else  // even case
            {
                pixel = (pixel >> 4) & 0x0000000f;
            }
            break;

        case 8:
            pixel = pixel & 0x000000ff;
            break;

        case 16:
            if (PGL_modecfg.depth == 555)
            {
                pixel = pixel & 0x00007fff;
            }
            else  // 565
            {
                pixel = pixel & 0x0000ffff;
            }
            break;

        case 24:
            pixel = pixel & 0x00ffffff;
            break;

        case 32:
            pixel = pixel & 0xffffffff;
            break;
    }

    return (pixel);
}

