/*******************************************************************************
 *	ATI 3D RAGE SDK sample code												   *	
 *																			   *
 *  Knight Demo																   *
 *																			   *
 *  Copyright (c) 1996-1997 ATI Technologies, Inc.  All rights reserved.	   *	
 *																			   *
 * Written by Aaron Orenstein												   *
 *  																		   *
 *	The base sequence and set up for the stone to knight texture morph 		   *
 *	for the start of the Knight Demo. Involves texture compositing of the 	   *
 *	stone texture of the knight statue with the texture(s) for the living	   *
 *	knight. Includes initialization, drawing and texture compositing, and	   *
 *	clean-up for the knight morph.											   *
 *******************************************************************************/
#ifndef MORPH_H
#define MORPH_H
// -----------------------------------------------------------------------------

#include "AtiDemo.h"
#include "NormalMode.h"
#include "script.h"

// -----------------------------------------------------------------------------

class Morph {
public:
	static void Cleanup(void) throw(Exception);
	static void Initialize(void) throw(Exception);

	static void Physics(PhysicsType type) throw();

	static void SetMode(void);

private:
	static void DoCopy(void);

	static void DrawKnightOverride(Clipper& rClipper) throw(Exception);
};

// -----------------------------------------------------------------------------

extern CameraScript* g_pCameraScript;

// -----------------------------------------------------------------------------
#endif
