/*******************************************************************************
 *	ATI 3D RAGE SDK sample code												   *	
 *																			   *
 *  Knight Demo																   *
 *																			   *
 *  Copyright (c) 1996-1997 ATI Technologies, Inc.  All rights reserved.	   *	
 *  																		   *
 * Written by Aaron Orenstein												   *
 *  																		   *
 *  																		   *
 *  File utilities for reading and writing the landscape object data.		   *
 *******************************************************************************/
#include "stdwin.h"
#include <math.h>
#include "Util.h"
#include "DirectDraw.h"
#include "Watchers.h"

#include "Ati3dCIFx.h"
#include "Matrix.h"
#include "Vertex.h"
#include "Clipper.h"
#include "XForm.h"
#include "Intersect.h"

#include "Landscape.h"

// -----------------------------------------------------------------------------

#define ALD_VERSION_0	'ALD0'
#define ALD_VERSION_1	'ALD1'

// -----------------------------------------------------------------------------

void LandSquare::Write(fileHandle& fh) throw(Exception, FH_Exception)
{
	RecomputeNormals();

	fh.writeUint32('SQRE');

	fh.writeUint32(m_bitFlags);

	for(int i=0; i<4; i++)
	{
		fh.writeReal32(m_surfaceHeight[i]);
		fh.writeReal32(m_surfaceUV[i].U());
		fh.writeReal32(m_surfaceUV[i].V());
		fh.writeReal32(m_northFaceUV[i].U());
		fh.writeReal32(m_northFaceUV[i].V());
		fh.writeReal32(m_eastFaceUV[i].U());
		fh.writeReal32(m_eastFaceUV[i].V());
	}

	fh.writeReal32(m_surfaceColor.R());
	fh.writeReal32(m_surfaceColor.G());
	fh.writeReal32(m_surfaceColor.B());
	fh.writeReal32(m_surfaceColor.A());

	fh.writeReal32(m_northFaceColor.R());
	fh.writeReal32(m_northFaceColor.G());
	fh.writeReal32(m_northFaceColor.B());
	fh.writeReal32(m_northFaceColor.A());

	fh.writeReal32(m_eastFaceColor.R());
	fh.writeReal32(m_eastFaceColor.G());
	fh.writeReal32(m_eastFaceColor.B());
	fh.writeReal32(m_eastFaceColor.A());

	fh.writeReal32(WaterLevel());
	for(i=0; i<4; i++)
	{
		fh.writeReal32(WaterColor(i).R());
		fh.writeReal32(WaterColor(i).G());
		fh.writeReal32(WaterColor(i).B());
		fh.writeReal32(WaterColor(i).A());
	}
}



void LandSquare::Read(fileHandle& fh, uint32 version) throw(Exception, FH_Exception)
{
	if(fh.readUint32() != 'SQRE') THROW_EXCEPTION();

	m_bitFlags = fh.readUint32();

	for(int i=0; i<4; i++)
	{
		m_surfaceHeight[i] = fh.readReal32();
		m_surfaceUV[i].U() = fh.readReal32();
		m_surfaceUV[i].V() = fh.readReal32();
		m_northFaceUV[i].U() = fh.readReal32();
		m_northFaceUV[i].V() = fh.readReal32();
		m_eastFaceUV[i].U() = fh.readReal32();
		m_eastFaceUV[i].V() = fh.readReal32();
	}
	
	m_surfaceColor.R() = fh.readReal32();
	m_surfaceColor.G() = fh.readReal32();
	m_surfaceColor.B() = fh.readReal32();
	m_surfaceColor.A() = fh.readReal32();

	m_northFaceColor.R() = fh.readReal32();
	m_northFaceColor.G() = fh.readReal32();
	m_northFaceColor.B() = fh.readReal32();
	m_northFaceColor.A() = fh.readReal32();

	m_eastFaceColor.R() = fh.readReal32();
	m_eastFaceColor.G() = fh.readReal32();
	m_eastFaceColor.B() = fh.readReal32();
	m_eastFaceColor.A() = fh.readReal32();

	if(version == ALD_VERSION_0)
	{
		WaterLevel() = 0;
		for(i=0; i<4; i++)
		{
			WaterColor(i).R() = 64;
			WaterColor(i).G() = 64;
			WaterColor(i).B() = 255;
			WaterColor(i).A() = 192;
		}
	}
	else
	{
		WaterLevel() = fh.readReal32();
		for(i=0; i<4; i++)
		{
			WaterColor(i).R() = fh.readReal32();
			WaterColor(i).G() = fh.readReal32();
			WaterColor(i).B() = fh.readReal32();
			WaterColor(i).A() = fh.readReal32();
		}
	}
}

// -----------------------------------------------------------------------------

void Landscape::Write(fileHandle& fh) throw(Exception, FH_Exception)
{
	fh.writeInt32(ALD_VERSION_1);

	for(int j=0; j<17; j++)
		for(int i=0; i<17; i++)
			Square(i, j).Write(fh);
}



void Landscape::Write(char* filename) throw(Exception, FH_Exception)
{
	fileHandle fh(filename, "wb");
	Write(fh);
}

// -----------------------------------------------------------------------------

void Landscape::Read(fileHandle& fh) throw(Exception, FH_Exception)
{
	uint32 version = fh.readInt32();
	if((version != ALD_VERSION_0) && (version != ALD_VERSION_1)) THROW_EXCEPTION();

	for(int j=0; j<17; j++)
		for(int i=0; i<17; i++)
			Square(i, j).Read(fh, version);

	for(j=0; j<17; j++)
		for(int i=0; i<17; i++)
			Square(i, j).RecomputeNormals();
}



void Landscape::Read(char* filename) throw(Exception, FH_Exception)
{
	fileHandle fh(filename, "rb");
	Read(fh);
}

// -----------------------------------------------------------------------------
